<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TherapistCommunityReview extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = "therapist_community_reviews";
    protected $fillable = ['therapist_community_id', 'customer_id', 'rating','experience','communication','service', 'comment', 'is_active', 'deleted_at'];


    public function scopeWithAll($query)
    {
        return $query->with('customer');
    }
    public function scopeActive($query)
    {
        return $query->where('is_active', 1);
    }
    public function scopeFeatured($query)
    {
        return $query->where('is_featured', 1);
    }
    public function therapist_community()
    {
        return $this->belongsTo(TherapistCommunity::class);
    }
    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }
}
